------------------------------------------------------------------------------
--	FILE:	 GreatestEarthMap.lua
--  by djvandyke
--  Imported to Civ VI by Gedemon (2016)
------------------------------------------------------------------------------

include "MapEnums"
include "MapUtilities"
include "MountainsCliffs"
include "RiversLakes"
include "FeatureGenerator"
include "TerrainGenerator"
include "NaturalWonderGenerator"
include "ResourceGenerator"
include "AssignStartingPlots"

local mapName = MapConfiguration.GetValue("MapName")
print("Loading "..tostring(mapName).." script")

local g_iW = 104
local g_iH = 64
local g_iFlags = {};
local g_continentsFrac = nil;

------------------------------------------------------------------------------
-- The application side will call GetMapScriptInfo directly to request
-- information about the map script.
-------------------------------------------------------------------------------
function GetMapInitData(worldSize)
	return {
		Width = g_iW,
		Height = g_iH,
		WrapX = true,
		WrapY = false,
	};      
end

-------------------------------------------------------------------------------
function GenerateMap()
	print("Calling Map Generator");
	-- Everything has been moved to the modded AssignStartingPlots in the "override" folder, search for "YnAMP" string in that file
	GenerateImportedMap(GetMap(), GetCiv6DataToConvert(), GetNaturalWonders(), g_iW, g_iH)
end

function GetNaturalWonders()
	local NaturalWonders = {}
	
	NaturalWonders[GameInfo.Features["FEATURE_BARRIER_REEF"].Index] 	= { X = 103, Y = 16}	
	NaturalWonders[GameInfo.Features["FEATURE_CLIFFS_DOVER"].Index] 	= { X = 39, Y = 51}
	NaturalWonders[GameInfo.Features["FEATURE_CRATER_LAKE"].Index] 		= { X = 3, Y = 48}	
	NaturalWonders[GameInfo.Features["FEATURE_DEAD_SEA"].Index] 		= { X = 63, Y = 37}	
	NaturalWonders[GameInfo.Features["FEATURE_EVEREST"].Index] 			= { X = 78, Y = 42}	
	NaturalWonders[GameInfo.Features["FEATURE_GALAPAGOS"].Index] 		= { X = 15, Y = 20}
	NaturalWonders[GameInfo.Features["FEATURE_KILIMANJARO"].Index] 		= { X = 62, Y = 17}	
	NaturalWonders[GameInfo.Features["FEATURE_PANTANAL"].Index] 		= { X = 27, Y = 16}	
	NaturalWonders[GameInfo.Features["FEATURE_PIOPIOTAHI"].Index] 		= { X = 0, Y = 6}
	NaturalWonders[GameInfo.Features["FEATURE_TORRES_DEL_PAINE"].Index] = { X = 25, Y = 6}
	NaturalWonders[GameInfo.Features["FEATURE_TSINGY"].Index] 			= { X = 64, Y = 9}
	NaturalWonders[GameInfo.Features["FEATURE_YOSEMITE"].Index] 		= { X = 2, Y = 45}
	
	return NaturalWonders
end

function GetCiv6DataToConvert()
	local Civ6DataToConvert = {}
	for i = 0, g_iW - 1, 1 do
		Civ6DataToConvert[i] = {}
	end
	
	-- Civ6 Data (copy from Lua.log below and on each lines remove everything before "Civ6DataToConvert")
	-- Civ6DataToConvert[x][y]={{IsNEOfCliff,IsWOfCliff,IsNWOfCliff},}
	
	-- End of Cliffs table
	return Civ6DataToConvert
end

function GetMap()

	local MapToConvert = {}
	for i = 0, g_iW - 1, 1 do
		MapToConvert[i] = {}
	end
	
	-- Map Data
	-- MapToConvert[x][y] = {civ5TerrainType, civ5PlotTypes, civ5FeatureTypes, civ5ContinentType, {{IsNEOfRiver, flow}, {IsWOfRiver, flow}, {IsNWOfRiver, flow}}, {Civ5ResourceType, num} }
	
 MapToConvert[0][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][0]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][0]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][0]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][0]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][0]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][1]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][1]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][1]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][1]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][1]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][2]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][2]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][3]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][3]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][3]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][3]={3,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[31][3]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][3]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][3]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][3]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][3]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][4]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][4]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][4]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][4]={1,1,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[32][4]={3,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][4]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][4]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][4]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][4]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][4]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][4]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][5]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][5]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][5]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][5]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][5]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][5]={2,2,4,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[54][5]={2,2,4,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[55][5]={1,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[56][5]={1,2,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[57][5]={0,0,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[58][5]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][5]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][5]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][5]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][6]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][6]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][6]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][6]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][6]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][6]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][6]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][6]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][6]={0,1,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[58][6]={1,0,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[59][6]={1,1,5,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[60][6]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][6]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][6]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][7]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][7]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][7]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][7]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][7]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][7]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][7]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][7]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][7]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][7]={0,2,5,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[58][7]={1,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][7]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][7]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][7]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][7]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][7]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][8]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][8]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][8]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][8]={0,1,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[28][8]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][8]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][8]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][8]={1,1,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[60][8]={0,2,5,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][8]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][8]={0,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[66][8]={0,0,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][8]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][8]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][8]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][8]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][9]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][9]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][9]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][9]={0,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[28][9]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][9]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][9]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][9]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[56][9]={0,2,5,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[57][9]={0,2,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[58][9]={0,2,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[59][9]={0,1,-1,3,{{1,2},{0,-1},{1,4}},{-1,0}}
 MapToConvert[60][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][9]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][9]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][9]={1,2,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[66][9]={1,1,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][9]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][10]={0,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[4][10]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][10]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][10]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][10]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][10]={0,2,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[29][10]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][10]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][10]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][10]={1,2,-1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[57][10]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][10]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][10]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][10]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][10]={0,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[66][10]={1,1,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][10]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][10]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][10]={0,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[100][10]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][10]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][11]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][11]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][11]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][11]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][11]={0,2,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[29][11]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][11]={1,2,5,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[56][11]={0,2,5,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][11]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][11]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][11]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][11]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][11]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][11]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][11]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][11]={1,2,-1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[100][11]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][11]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][12]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][12]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][12]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][12]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[29][12]={0,1,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][12]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][12]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][12]={1,1,5,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[56][12]={0,1,5,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][12]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][12]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][12]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][12]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][12]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][12]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][12]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][12]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][12]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][12]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][12]={1,2,5,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[101][12]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][12]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][13]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][13]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][13]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][13]={0,0,15,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][13]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][13]={1,2,1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[29][13]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][13]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][13]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][13]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][13]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][13]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][13]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][13]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][13]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][13]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][13]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][13]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][13]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][13]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][13]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][13]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][14]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][14]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][14]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][14]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][14]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][14]={0,1,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[30][14]={0,0,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[31][14]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][14]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][14]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][14]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][14]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][14]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][14]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][14]={0,2,2,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][14]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][14]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][14]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][14]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][14]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][14]={2,2,21,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][14]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][14]={1,2,5,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[101][14]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][14]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][15]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][15]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][15]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][15]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][15]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][15]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][15]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][15]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][15]={1,1,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[29][15]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][15]={1,1,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[31][15]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][15]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][15]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][15]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][15]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][15]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[57][15]={0,0,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[58][15]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][15]={1,1,1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[61][15]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][15]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][15]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][15]={0,2,5,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[101][15]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][16]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][16]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][16]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][16]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][16]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][16]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][16]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][16]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][16]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][16]={0,2,2,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[30][16]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][16]={1,1,5,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[32][16]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][16]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][16]={1,2,1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[53][16]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][16]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][16]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][16]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[57][16]={1,1,1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[58][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][16]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][16]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][16]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][16]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][16]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][16]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][16]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][16]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][16]={5,3,10,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][17]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][17]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][17]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][17]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][17]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][17]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][17]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][17]={0,2,16,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][17]={1,1,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[29][17]={0,2,2,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][17]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][17]={1,1,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[32][17]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][17]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][17]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][17]={1,1,1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[53][17]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][17]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][17]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][17]={1,1,1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[57][17]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][17]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][17]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][17]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][17]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][17]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][17]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][17]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][17]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][17]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][17]={5,3,10,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][18]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][18]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][18]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][18]={3,0,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[24][18]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][18]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][18]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][18]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[28][18]={1,1,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][18]={0,2,2,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[30][18]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][18]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][18]={1,2,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[33][18]={1,2,1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[34][18]={0,2,2,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][18]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][18]={1,2,1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[54][18]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][18]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][18]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[57][18]={0,0,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][18]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][18]={1,1,1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[63][18]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][18]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][18]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][19]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][19]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][19]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][19]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][19]={3,0,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[23][19]={0,1,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][19]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][19]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][19]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][19]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[28][19]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[29][19]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][19]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][19]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][19]={1,1,5,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[33][19]={1,1,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][19]={0,2,2,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[51][19]={0,2,2,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][19]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][19]={1,1,1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[54][19]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][19]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[56][19]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][19]={0,0,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[58][19]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][19]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][19]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][19]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][19]={1,1,1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[63][19]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][19]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][19]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][20]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][20]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][20]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][20]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][20]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][20]={0,1,-1,1,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[24][20]={0,2,2,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[25][20]={0,2,2,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[26][20]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][20]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][20]={0,2,2,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[29][20]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[30][20]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][20]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][20]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][20]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][20]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][20]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][20]={0,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][20]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][20]={0,2,2,3,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[51][20]={1,2,1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][20]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][20]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][20]={1,1,1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[55][20]={1,2,1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[56][20]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][20]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][20]={0,0,-1,3,{{1,2},{0,-1},{1,4}},{-1,0}}
 MapToConvert[59][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][20]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][20]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][20]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][20]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][20]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][20]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][21]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][21]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][21]={0,1,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[21][21]={0,1,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[22][21]={0,1,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[23][21]={0,1,-1,1,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[24][21]={1,2,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[25][21]={1,2,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[26][21]={0,2,2,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[27][21]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[28][21]={1,2,1,1,{{1,5},{1,0},{0,-1}},{-1,0}}
 MapToConvert[29][21]={0,2,2,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][21]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][21]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][21]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][21]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][21]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][21]={1,2,1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[46][21]={0,2,2,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][21]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][21]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][21]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][21]={1,2,1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[51][21]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][21]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][21]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][21]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][21]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][21]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][21]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][21]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][21]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][21]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][21]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][21]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][22]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][22]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][22]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][22]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][22]={0,2,2,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[24][22]={0,2,2,1,{{1,2},{1,0},{0,-1}},{-1,0}}
 MapToConvert[25][22]={0,0,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[26][22]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][22]={1,2,1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[28][22]={0,0,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[29][22]={1,2,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[30][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][22]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][22]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][22]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][22]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][22]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][22]={1,1,1,3,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[46][22]={1,1,1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][22]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][22]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][22]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][22]={1,2,1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[51][22]={0,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][22]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][22]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][22]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][22]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][22]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][22]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][22]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][22]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][22]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][22]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][22]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][22]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][22]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][22]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][22]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][22]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][22]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][23]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][23]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][23]={0,2,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[24][23]={0,0,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][23]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][23]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][23]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][23]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][23]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][23]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][23]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][23]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][23]={0,2,-1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[46][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][23]={0,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[50][23]={0,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][23]={0,1,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[53][23]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][23]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][23]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][23]={0,2,5,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[60][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][23]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][23]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][23]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][23]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][23]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][23]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][23]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][23]={1,2,1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][23]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][23]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][23]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][23]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][23]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][24]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][24]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][24]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][24]={1,2,1,1,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[25][24]={0,2,2,1,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[26][24]={0,2,2,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[27][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][24]={1,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[41][24]={1,1,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[42][24]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][24]={1,1,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[46][24]={1,1,-1,3,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[47][24]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][24]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[50][24]={1,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][24]={0,2,2,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][24]={0,2,2,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[53][24]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][24]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][24]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][24]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][24]={0,2,5,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[61][24]={0,2,5,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[62][24]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][24]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][24]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][24]={0,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][24]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][24]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][24]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][25]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][25]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][25]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][25]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][25]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][25]={1,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[40][25]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][25]={1,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[42][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][25]={1,1,-1,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[45][25]={1,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][25]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][25]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[48][25]={1,2,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[49][25]={1,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][25]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][25]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][25]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][25]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][25]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][25]={0,1,5,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[62][25]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][25]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][25]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][25]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][25]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][26]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][26]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][26]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][26]={1,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[43][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][26]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[47][26]={1,2,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[48][26]={1,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][26]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][26]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][26]={1,1,-1,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[61][26]={0,1,-1,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[62][26]={0,0,-1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[63][26]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][26]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][26]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][26]={0,2,11,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][26]={5,3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][26]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][26]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][27]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][27]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][27]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][27]={2,2,4,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[43][27]={2,2,4,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[44][27]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][27]={2,2,4,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[46][27]={2,2,4,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][27]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][27]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][27]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][27]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][27]={1,2,5,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[61][27]={0,2,-1,3,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[62][27]={1,0,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][27]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][27]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][27]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][27]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][27]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][27]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][27]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][27]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][27]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][27]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][27]={0,2,1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][28]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][28]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][28]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][28]={2,2,-1,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[45][28]={2,1,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[46][28]={2,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][28]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][28]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][28]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][28]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][28]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[61][28]={1,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][28]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][28]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][28]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][28]={0,0,18,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][28]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][28]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][28]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][28]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][28]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][28]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][29]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][29]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][29]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][29]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][29]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][29]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][29]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][29]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][29]={2,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[60][29]={2,1,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][29]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][29]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][29]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][29]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][29]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][29]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][29]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][29]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][29]={1,2,1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[87][29]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][29]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][29]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][29]={0,2,1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][30]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][30]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][30]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][30]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][30]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][30]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][30]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][30]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][30]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][30]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][30]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][30]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][30]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][30]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][30]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][30]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][30]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][30]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][30]={2,2,4,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[61][30]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][30]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][30]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][30]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][30]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][30]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][30]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][30]={1,2,1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[88][30]={1,1,1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][31]={1,1,5,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[2][31]={0,0,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[3][31]={0,1,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][31]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][31]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][31]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][31]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[16][31]={0,2,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[17][31]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][31]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][31]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][31]={1,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[40][31]={1,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[41][31]={1,2,-1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[42][31]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][31]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][31]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][31]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][31]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][31]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][31]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][31]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][31]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[59][31]={2,2,4,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[60][31]={2,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][31]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][31]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][31]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][31]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][31]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][32]={1,1,5,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][32]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][32]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][32]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][32]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][32]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][32]={0,2,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[16][32]={0,2,2,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][32]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][32]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][32]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][32]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][32]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][32]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][32]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][32]={2,0,-1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[43][32]={2,0,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][32]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][32]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][32]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][32]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][32]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][32]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[59][32]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][32]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][32]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][32]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][32]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][32]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][32]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][32]={0,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][32]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][32]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][32]={0,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][33]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][33]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][33]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][33]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][33]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][33]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][33]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][33]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][33]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][33]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][33]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][33]={0,2,12,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][33]={1,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[41][33]={1,1,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[42][33]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][33]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][33]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][33]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][33]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][33]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][33]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][33]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][33]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][33]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][33]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][33]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][33]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][33]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][33]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][33]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][33]={2,2,4,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[59][33]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][33]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][33]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][33]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][33]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][33]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][33]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][33]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][33]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][33]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][33]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][33]={0,0,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[77][33]={0,2,1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][33]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][33]={0,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][33]={0,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][33]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][34]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][34]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][34]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][34]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][34]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][34]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][34]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][34]={1,1,1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[28][34]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][34]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[37][34]={1,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[38][34]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][34]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][34]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][34]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][34]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][34]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][34]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][34]={1,0,-1,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[48][34]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][34]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][34]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][34]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][34]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][34]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][34]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[59][34]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][34]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][34]={2,0,19,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][34]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][34]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][34]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][34]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][34]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][34]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][34]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][34]={1,1,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[76][34]={0,1,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[77][34]={0,2,2,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[78][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][34]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][34]={0,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][35]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][35]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][35]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][35]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][35]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][35]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][35]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][35]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][35]={1,1,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][35]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[37][35]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][35]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][35]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][35]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][35]={1,2,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[47][35]={1,2,5,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][35]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][35]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[58][35]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][35]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][35]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][35]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][35]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][35]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][35]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][35]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][35]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][35]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][35]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][35]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][35]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][35]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][35]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][35]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][35]={0,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][35]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][36]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][36]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][36]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][36]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][36]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][36]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][36]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][36]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][36]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][36]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][36]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][36]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][36]={0,1,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[38][36]={0,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[39][36]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][36]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][36]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][36]={0,2,5,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[48][36]={0,2,5,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][36]={2,2,4,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[58][36]={2,2,4,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[59][36]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][36]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][36]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][36]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][36]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][36]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][36]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][36]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][36]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][36]={0,2,-1,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[76][36]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][36]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][36]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][36]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][36]={0,2,2,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[85][36]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][36]={0,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][36]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][36]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][37]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][37]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][37]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][37]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][37]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][37]={0,2,2,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[23][37]={0,2,2,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][37]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[34][37]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][37]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][37]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][37]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][37]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][37]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][37]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][37]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][37]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][37]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][37]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][37]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][37]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][37]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][37]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][37]={0,1,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[76][37]={0,1,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[77][37]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][37]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][37]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][37]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][37]={1,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[84][37]={0,2,2,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][37]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][37]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][37]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][38]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][38]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][38]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][38]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][38]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][38]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][38]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][38]={0,1,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[35][38]={0,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[36][38]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[37][38]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][38]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][38]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][38]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][38]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][38]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][38]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][38]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][38]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][38]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][38]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][38]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][38]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][38]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][38]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][38]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][38]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][38]={2,2,4,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[74][38]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][38]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][38]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][38]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][38]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][38]={0,2,2,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[80][38]={0,2,2,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][38]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][38]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][38]={1,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[84][38]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][38]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][38]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][38]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][39]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][39]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][39]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][39]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][39]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][39]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][39]={1,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[12][39]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][39]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][39]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][39]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][39]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[37][39]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][39]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][39]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][39]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][39]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][39]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][39]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][39]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][39]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][39]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][39]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][39]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][39]={2,2,4,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[66][39]={2,2,4,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[67][39]={2,2,4,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][39]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][39]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][39]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][39]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][39]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][39]={2,2,4,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[74][39]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][39]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[76][39]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[77][39]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[78][39]={0,2,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[79][39]={1,2,1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][39]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[81][39]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[82][39]={0,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[83][39]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][39]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][39]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][40]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][40]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][40]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][40]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][40]={2,0,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[10][40]={1,1,-1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[11][40]={1,1,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[12][40]={0,1,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][40]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][40]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][40]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[19][40]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][40]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][40]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][40]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][40]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][40]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[41][40]={1,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[42][40]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][40]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][40]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][40]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][40]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][40]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][40]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][40]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][40]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][40]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][40]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][40]={2,2,4,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[66][40]={2,2,4,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][40]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][40]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][40]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][40]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][40]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][40]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][40]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][40]={0,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[75][40]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[76][40]={0,2,2,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][40]={0,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][40]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][40]={1,2,1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[80][40]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[81][40]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][40]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][40]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][40]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][40]={0,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][40]={0,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[89][40]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][40]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][41]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][41]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][41]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][41]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][41]={2,0,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[9][41]={1,1,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][41]={1,1,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[11][41]={1,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][41]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][41]={0,2,2,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[14][41]={0,2,2,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][41]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][41]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][41]={0,2,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[18][41]={0,2,2,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][41]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][41]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][41]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][41]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][41]={0,0,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[40][41]={1,0,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][41]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][41]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][41]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][41]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][41]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[57][41]={1,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][41]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][41]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[65][41]={2,2,4,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][41]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][41]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][41]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][41]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][41]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][41]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][41]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][41]={3,1,5,2,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[75][41]={3,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][41]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][41]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][41]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][41]={3,0,-1,2,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[80][41]={3,0,-1,2,{{1,2},{0,-1},{1,4}},{-1,0}}
 MapToConvert[81][41]={0,2,-1,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[82][41]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][41]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][41]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][41]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][41]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][42]={2,1,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[5][42]={2,2,4,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][42]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][42]={2,2,7,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][42]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][42]={1,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[10][42]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][42]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][42]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][42]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][42]={0,2,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[15][42]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][42]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][42]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][42]={0,2,2,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[19][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][42]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][42]={0,1,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[40][42]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][42]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][42]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][42]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][42]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][42]={0,1,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[58][42]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][42]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][42]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][42]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][42]={1,1,-1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[66][42]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][42]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][42]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][42]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][42]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][42]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][42]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][42]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][42]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][42]={4,0,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[76][42]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][42]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][42]={4,0,20,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][42]={4,1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[80][42]={3,0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][42]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][42]={0,2,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[83][42]={0,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[84][42]={1,2,1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[85][42]={1,1,1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][42]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][42]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][42]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][42]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][43]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][43]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][43]={2,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[5][43]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][43]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][43]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][43]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][43]={1,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[10][43]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][43]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][43]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][43]={0,1,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[14][43]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][43]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][43]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][43]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][43]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[39][43]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][43]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][43]={0,1,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[50][43]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][43]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][43]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][43]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][43]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][43]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][43]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][43]={1,0,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[65][43]={1,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][43]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][43]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][43]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][43]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][43]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][43]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][43]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][43]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][43]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][43]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][43]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][43]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][43]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][43]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][43]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][43]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][43]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][43]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][43]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][43]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][43]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][43]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][43]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][43]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][43]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][43]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][44]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][44]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][44]={2,0,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[5][44]={2,2,4,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][44]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][44]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][44]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][44]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][44]={1,1,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[11][44]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][44]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][44]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][44]={0,2,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[15][44]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][44]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][44]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][44]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][44]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][44]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[39][44]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][44]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[44][44]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][44]={0,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[51][44]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][44]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[55][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][44]={1,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[57][44]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][44]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[60][44]={1,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][44]={2,2,4,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[62][44]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][44]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][44]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][44]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][44]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][44]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][44]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][44]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][44]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][44]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][44]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][44]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][44]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][44]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][44]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][44]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][44]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][44]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][44]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][44]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][44]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][44]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][44]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][44]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][44]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][45]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][45]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][45]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][45]={2,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[5][45]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][45]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][45]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][45]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][45]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[10][45]={1,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][45]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][45]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][45]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[14][45]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][45]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][45]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][45]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][45]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][45]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][45]={1,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[42][45]={0,0,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][45]={1,1,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[44][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][45]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][45]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][45]={1,1,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[51][45]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][45]={1,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[55][45]={1,1,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[56][45]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][45]={1,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[60][45]={1,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][45]={0,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[62][45]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][45]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][45]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][45]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][45]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][45]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][45]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][45]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][45]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][45]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][45]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][45]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][45]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][45]={3,0,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[82][45]={1,1,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[83][45]={0,1,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[84][45]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][45]={0,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[86][45]={0,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][45]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][45]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][45]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][45]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][46]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][46]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][46]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][46]={2,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[6][46]={2,2,4,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][46]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][46]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][46]={1,1,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[10][46]={1,1,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][46]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][46]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][46]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[14][46]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][46]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][46]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][46]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][46]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][46]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][46]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][46]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[39][46]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[40][46]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[41][46]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[42][46]={0,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][46]={1,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[44][46]={0,2,5,4,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[45][46]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][46]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][46]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][46]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][46]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][46]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][46]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][46]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][46]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][46]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][46]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][46]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][46]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][46]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][46]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][46]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][46]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][46]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][46]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][46]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][46]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][46]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][46]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][46]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[85][46]={0,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[86][46]={0,2,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[87][46]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][46]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][46]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][46]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][46]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][46]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][46]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][46]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][47]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][47]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][47]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][47]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][47]={2,2,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[6][47]={2,1,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[7][47]={1,2,9,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[8][47]={1,1,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][47]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][47]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][47]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][47]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[13][47]={0,1,-1,1,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[14][47]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][47]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][47]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][47]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][47]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][47]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][47]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][47]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[40][47]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][47]={1,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[43][47]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][47]={0,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[45][47]={0,0,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[46][47]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[47][47]={0,2,5,4,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[48][47]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[49][47]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[50][47]={1,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[51][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][47]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][47]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][47]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][47]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][47]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][47]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][47]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][47]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][47]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][47]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][47]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][47]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][47]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][47]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][47]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][47]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][47]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][47]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][47]={0,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[87][47]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][47]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][47]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][47]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][47]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][48]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][48]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][48]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][48]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][48]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][48]={2,1,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[8][48]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][48]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][48]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][48]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][48]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[13][48]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][48]={0,2,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[15][48]={0,2,5,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[16][48]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][48]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][48]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][48]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][48]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][48]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][48]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][48]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][48]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][48]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[41][48]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[42][48]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[43][48]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][48]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][48]={3,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[48][48]={0,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][48]={1,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[51][48]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[52][48]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][48]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][48]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[56][48]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[57][48]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[58][48]={0,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][48]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][48]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][48]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][48]={2,2,4,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][48]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][48]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][48]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][48]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][48]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][48]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][48]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][48]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][48]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][48]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][48]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][48]={0,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[86][48]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][48]={0,2,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[88][48]={0,2,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][48]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][48]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][48]={0,2,8,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[100][48]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][49]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][49]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][49]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][49]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][49]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][49]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][49]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][49]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][49]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][49]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[12][49]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][49]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][49]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][49]={0,2,5,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[16][49]={0,2,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[17][49]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][49]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][49]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][49]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][49]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][49]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][49]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[40][49]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][49]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][49]={0,1,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[46][49]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][49]={3,0,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[48][49]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][49]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][49]={0,0,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][49]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][49]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][49]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][49]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[55][49]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][49]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][49]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][49]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][49]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][49]={2,2,4,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[68][49]={2,2,4,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][49]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][49]={2,2,4,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[71][49]={1,0,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][49]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][49]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][49]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][49]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][49]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][49]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][49]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][49]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][49]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][49]={1,1,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[83][49]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][49]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][49]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[86][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][49]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][49]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][49]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][49]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][49]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][49]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][50]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][50]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][50]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][50]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][50]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][50]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][50]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][50]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[10][50]={0,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[11][50]={0,2,-1,1,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[12][50]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][50]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][50]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][50]={0,2,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[18][50]={0,2,5,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[19][50]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][50]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][50]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][50]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][50]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][50]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][50]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][50]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][50]={0,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[47][50]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[48][50]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][50]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[50][50]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[51][50]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[52][50]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[53][50]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[54][50]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[55][50]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][50]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][50]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][50]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][50]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[62][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][50]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[68][50]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][50]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][50]={2,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[72][50]={2,2,4,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[73][50]={2,2,4,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[74][50]={1,0,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][50]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][50]={1,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[82][50]={1,2,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[83][50]={1,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[84][50]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][50]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][50]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][50]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][50]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[93][50]={0,1,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][50]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][50]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][51]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][51]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][51]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][51]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][51]={1,2,5,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[6][51]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][51]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][51]={0,1,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[9][51]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][51]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][51]={0,2,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[12][51]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][51]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][51]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][51]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][51]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][51]={0,2,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[19][51]={0,1,5,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][51]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][51]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][51]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][51]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][51]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][51]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[45][51]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[46][51]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][51]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][51]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[51][51]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][51]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][51]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][51]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][51]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][51]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][51]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][51]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[61][51]={1,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][51]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][51]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[68][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][51]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][51]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][51]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][51]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][51]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][51]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][51]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][51]={1,1,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[83][51]={1,0,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][51]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][51]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][51]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][51]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][51]={0,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[92][51]={0,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][51]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][51]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][51]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][51]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][52]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][52]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][52]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][52]={1,2,13,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][52]={1,2,5,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[7][52]={0,1,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[8][52]={0,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[9][52]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][52]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][52]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[12][52]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][52]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][52]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][52]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][52]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][52]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][52]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][52]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][52]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][52]={1,1,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[37][52]={1,1,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[38][52]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][52]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[40][52]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[41][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][52]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][52]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[45][52]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][52]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[49][52]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[50][52]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[51][52]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][52]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[53][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][52]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][52]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][52]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][52]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[62][52]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][52]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[67][52]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[68][52]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][52]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][52]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][52]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][52]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][52]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][52]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][52]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][52]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][52]={1,1,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[84][52]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][52]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[86][52]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[87][52]={0,2,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[88][52]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][52]={0,1,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[93][52]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][52]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][52]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][53]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][53]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][53]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][53]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][53]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][53]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][53]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][53]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][53]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[11][53]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][53]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][53]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][53]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][53]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][53]={0,1,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[20][53]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][53]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][53]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][53]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][53]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][53]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][53]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][53]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][53]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][53]={0,1,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[39][53]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][53]={0,2,2,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[44][53]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][53]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[49][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][53]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[52][53]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][53]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[56][53]={0,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[57][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][53]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[60][53]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[61][53]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][53]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[67][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][53]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][53]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][53]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][53]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][53]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][53]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][53]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][53]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][53]={1,1,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[84][53]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[85][53]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][53]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][53]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][53]={0,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[92][53]={0,0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][53]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][53]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][54]={0,2,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[3][54]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][54]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][54]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][54]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][54]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][54]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][54]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][54]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][54]={0,1,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[12][54]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][54]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][54]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][54]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][54]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][54]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][54]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][54]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][54]={0,1,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[21][54]={0,2,-1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[22][54]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][54]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][54]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][54]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][54]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][54]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][54]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][54]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][54]={1,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[47][54]={1,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[48][54]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[49][54]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][54]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[52][54]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][54]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[58][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][54]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[61][54]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][54]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[65][54]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[66][54]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[67][54]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][54]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][54]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][54]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][54]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][54]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][54]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][54]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][54]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][54]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][54]={1,1,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[85][54]={1,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][54]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][54]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][55]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][55]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][55]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][55]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][55]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][55]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][55]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][55]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][55]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][55]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][55]={3,1,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][55]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][55]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][55]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][55]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][55]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][55]={3,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[21][55]={3,1,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[22][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][55]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][55]={1,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][55]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][55]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][55]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][55]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[51][55]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][55]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[58][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][55]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][55]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][55]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[64][55]={0,2,5,4,{{1,2},{0,-1},{1,4}},{-1,0}}
 MapToConvert[65][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][55]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][55]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][55]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][55]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][55]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][55]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][55]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][55]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][55]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][55]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][55]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][55]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][55]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][55]={0,2,5,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[91][55]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][55]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][56]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][56]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][56]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][56]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][56]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][56]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][56]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][56]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][56]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][56]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][56]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][56]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][56]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][56]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][56]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][56]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][56]={3,1,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[21][56]={3,1,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][56]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][56]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][56]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][56]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][56]={0,1,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[39][56]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][56]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[47][56]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][56]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[57][56]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[58][56]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][56]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][56]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[64][56]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][56]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][56]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][56]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][56]={2,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][56]={2,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][56]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][56]={2,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][56]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][56]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][56]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][56]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][56]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][56]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][56]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][56]={0,0,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[92][56]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][56]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][56]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][57]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][57]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][57]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][57]={3,0,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[5][57]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][57]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][57]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][57]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][57]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][57]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][57]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][57]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][57]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][57]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][57]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][57]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][57]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][57]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][57]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][57]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][57]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][57]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][57]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][57]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][57]={0,1,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[47][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][57]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][57]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][57]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][57]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][57]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][57]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][57]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][57]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][57]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][57]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][57]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][57]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][57]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][57]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][57]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][57]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][57]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][57]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][57]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][58]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][58]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][58]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][58]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][58]={3,2,5,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[6][58]={3,1,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[7][58]={3,1,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[8][58]={3,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[9][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][58]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][58]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][58]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][58]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][58]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][58]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][58]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][58]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][58]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][58]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][58]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][58]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][58]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][58]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][58]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][58]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][58]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][58]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][58]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][58]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][58]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][58]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][58]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][58]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][58]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][58]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][58]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][58]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][58]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][58]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][58]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][58]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][58]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][58]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][59]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][59]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][59]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][59]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][59]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][59]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][59]={3,1,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[7][59]={3,1,-1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[8][59]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][59]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][59]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][59]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][59]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][59]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][59]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][59]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][59]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][59]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][59]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][59]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][59]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][59]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][59]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][59]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][59]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][59]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][59]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][59]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][59]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][59]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][59]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][59]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][59]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][59]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][59]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][59]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][59]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][59]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][59]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][59]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][59]={3,0,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[92][59]={3,2,5,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[93][59]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][59]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][60]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][60]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][60]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][60]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][60]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][60]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][60]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][60]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][60]={3,2,5,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[9][60]={3,2,5,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[10][60]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][60]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][60]={3,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[13][60]={3,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[14][60]={3,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[15][60]={3,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[16][60]={3,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[17][60]={3,2,-1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[18][60]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][60]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][60]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][60]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][60]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][60]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][60]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][60]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][60]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][60]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][60]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][60]={1,1,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[52][60]={1,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][60]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][60]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][60]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][60]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][60]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][60]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][60]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][60]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][60]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][60]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][60]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][60]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][60]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][60]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][60]={3,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[94][60]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][60]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][61]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][61]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][61]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][61]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][61]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][61]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][61]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][61]={3,1,5,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[10][61]={3,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[11][61]={3,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[12][61]={3,1,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][61]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][61]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][61]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][61]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][61]={3,2,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[18][61]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][61]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][61]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][61]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][61]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][61]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][61]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][61]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][61]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][61]={1,1,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[44][61]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][61]={0,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[52][61]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][61]={0,2,2,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[56][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][61]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][61]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][61]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][61]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][61]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][61]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][61]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][61]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][61]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][61]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][61]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][61]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][61]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][61]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][61]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][61]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][61]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][61]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][61]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][61]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][61]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][61]={3,1,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[93][61]={3,1,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][61]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][61]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][61]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][62]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][62]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][62]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][62]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][62]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][62]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][62]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][62]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][62]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][62]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][62]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][62]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][62]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][62]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][62]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][62]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][62]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][62]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][62]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][62]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][62]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][62]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][62]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][62]={0,1,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[44][62]={3,0,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[45][62]={3,0,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[46][62]={1,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[47][62]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][62]={0,2,2,4,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[53][62]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][62]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][62]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[57][62]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][62]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][62]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][62]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][62]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][62]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][62]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][62]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][62]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][62]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][62]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][62]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][62]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][63]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][63]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][63]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][63]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][63]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][63]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][63]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][63]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][63]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][63]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][63]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][63]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][63]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][63]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][63]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][63]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][63]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][63]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][63]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][63]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][63]={0,1,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[44][63]={3,0,-1,4,{{1,5},{1,3},{0,-1}},{-1,0}}
 MapToConvert[45][63]={3,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][63]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][63]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[48][63]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[49][63]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][63]={0,2,2,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[52][63]={0,1,-1,4,{{1,2},{0,-1},{1,4}},{-1,0}}
 MapToConvert[53][63]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[54][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][63]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][63]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[57][63]={1,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][63]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][63]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][63]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][63]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][63]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][63]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][63]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][63]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][63]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][63]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][63]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][63]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][63]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][63]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}

	

	
	return MapToConvert
end